extends Node2D
class_name HealthComponent

signal hit
@export var score_origin: Node2D
@export var max_health = 0
@onready var textLabel = $RichTextLabel
@onready var timer = $Timer
var health = 0

func _ready():
	textLabel.visible = false
	if score_origin:
		textLabel.position = score_origin
	health = max_health
#	textLabel.text = "[bgcolor=#d1e4e4]" + str(health) + "[/bgcolor]"


func _process(_delta):
	textLabel.text = "[center][color=red]" + str(health) + "[/color][/center]"
	
func damage(hitpoint):
	emit_signal("hit")
	health -= hitpoint
	textLabel.visible = true
	timer.start()
	if health < 0:
		# destroy in cool way
		# play animation
		get_parent().queue_free()



func _on_timer_timeout():
	textLabel.visible = false
